@extends('layouts.auth')
@section('title', __('Two-Factor Verification'))
@section('content')

<div class="page-ath-form">
    <h2 class="page-ath-heading">{{ __('2FA Authentication') }}</h2>
    <p>{{ __('Hello') }} <strong>{{ auth()->user()->name }}</strong>,
    <br>{{ __('Enter the verification code generated by your mobile application (Google Authenticator).') }}</p>
    @if(session()->has('2fa_notice'))
    <div class="alert alert-warning">{{ session('2fa_notice') }}</div>
    @endif
    <form id="active" action="{{ url()->current() }}" method="POST" autocomplete="off" class="validate-modern">
        @csrf
        <div class="input-item">
            <input name="one_time_password" type="text" required="required" data-msg-required="{{ __('Required.') }}" data-msg-maxlength="{{ __('Maximum :num chars.', ['num' => 6]) }}" placeholder="{{ __('Enter your authentication code') }}" class="input-bordered" autofocus="" maxlength="6">
        </div>
        <div class="d-flex justify-content-between align-items-center">
            <div>
                <button type="submit" class="btn btn-primary btn-block">{{ __('Sign in') }}</button>
            </div>
        </div>
    </form>
    <div class="gaps-2x"></div>
    <div class="form-note">
        {{ __('If you lost your phone or Uninstall the Google Authenticator app and enable to access your account please contact with us.') }}
    </div>
</div>

@endsection
